/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.object;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.object.LocationFactory;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Shape;
import java.lang.reflect.Field;
import sun.misc.Unsafe;

@ExportLibrary(value=DynamicDispatchLibrary.class)
public abstract class DynamicObject
implements TruffleObject {
    private Shape shape;
    private static final Unsafe UNSAFE = DynamicObject.getUnsafe();
    private static final long SHAPE_OFFSET;

    @Deprecated
    protected DynamicObject() {
        CompilerAsserts.neverPartOfCompilation();
        throw new UnsupportedOperationException();
    }

    protected DynamicObject(Shape shape) {
        DynamicObject.verifyShape(shape, this.getClass());
        this.shape = shape;
    }

    private static void verifyShape(Shape shape, Class<? extends DynamicObject> subclass) {
        Class<? extends DynamicObject> shapeType = shape.getLayout().getType();
        if (!(shapeType == subclass || shapeType.isAssignableFrom(subclass) && DynamicObject.class.isAssignableFrom(shapeType))) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalArgumentException("Incompatible shape");
        }
    }

    public final Shape getShape() {
        return DynamicObject.getShapeHelper(this.shape);
    }

    private static Shape getShapeHelper(Shape shape) {
        return shape;
    }

    final void setShape(Shape shape) {
        assert (shape.getLayout().getType().isInstance(this));
        this.setShapeHelper(shape, SHAPE_OFFSET);
    }

    private void setShapeHelper(Shape shape, long shapeOffset) {
        this.shape = shape;
    }

    public final Object get(Object key) {
        return this.get(key, null);
    }

    public abstract Object get(Object var1, Object var2);

    public abstract boolean set(Object var1, Object var2);

    public final boolean containsKey(Object key) {
        return this.getShape().getProperty(key) != null;
    }

    public final void define(Object key, Object value) {
        this.define(key, value, 0);
    }

    public abstract void define(Object var1, Object var2, int var3);

    public abstract void define(Object var1, Object var2, int var3, LocationFactory var4);

    public abstract boolean delete(Object var1);

    @Deprecated
    public int size() {
        return this.getShape().getPropertyCount();
    }

    @Deprecated
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public abstract void setShapeAndGrow(Shape var1, Shape var2);

    public abstract void setShapeAndResize(Shape var1, Shape var2);

    public abstract boolean updateShape();

    public abstract DynamicObject copy(Shape var1);

    private static Unsafe getUnsafe() {
        try {
            return Unsafe.getUnsafe();
        }
        catch (SecurityException securityException) {
            try {
                Field theUnsafeInstance = Unsafe.class.getDeclaredField("theUnsafe");
                theUnsafeInstance.setAccessible(true);
                return (Unsafe)theUnsafeInstance.get(Unsafe.class);
            }
            catch (Exception e) {
                throw new RuntimeException("exception while trying to get Unsafe.theUnsafe via reflection:", e);
            }
        }
    }

    static {
        try {
            SHAPE_OFFSET = UNSAFE.objectFieldOffset(DynamicObject.class.getDeclaredField("shape"));
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not get 'shape' field offset", e);
        }
    }

    @ExportMessage
    static class Dispatch {
        Dispatch() {
        }

        @Specialization(limit="1", guards={"cachedShape == receiver.getShape()"})
        static Class<?> doCachedShape(DynamicObject receiver, @Cached.Shared(value="cachedShape") @Cached(value="receiver.getShape()") Shape cachedShape, @Cached.Shared(value="cachedTypeClass") @Cached(value="receiver.getShape().getObjectType().getClass()", allowUncached=true) Class<? extends ObjectType> typeClass) {
            return cachedShape.getObjectType().dispatch();
        }

        @Specialization(replaces={"doCachedShape"})
        static Class<?> doCachedTypeClass(DynamicObject receiver, @Cached.Shared(value="cachedTypeClass") @Cached(value="receiver.getShape().getObjectType().getClass()", allowUncached=true) Class<? extends ObjectType> typeClass) {
            ObjectType objectType = CompilerDirectives.castExact(receiver.getShape().getObjectType(), typeClass);
            return objectType.dispatch();
        }
    }

    @ExportMessage
    static class Accepts {
        Accepts() {
        }

        @Specialization(limit="1", guards={"cachedShape == receiver.getShape()"})
        static boolean doCachedShape(DynamicObject receiver, @Cached.Shared(value="cachedShape") @Cached(value="receiver.getShape()") Shape cachedShape, @Cached.Shared(value="cachedTypeClass") @Cached(value="receiver.getShape().getObjectType().getClass()", allowUncached=true) Class<? extends ObjectType> typeClass) {
            return true;
        }

        @Specialization(replaces={"doCachedShape"})
        static boolean doCachedTypeClass(DynamicObject receiver, @Cached.Shared(value="cachedTypeClass") @Cached(value="receiver.getShape().getObjectType().getClass()", allowUncached=true) Class<? extends ObjectType> typeClass) {
            return typeClass == receiver.getShape().getObjectType().getClass();
        }
    }
}

