/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.instrumentation;

import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.function.BlockScopeNode;
import com.oracle.truffle.js.nodes.function.FunctionBodyNode;
import com.oracle.truffle.js.nodes.instrumentation.JSTags;
import com.oracle.truffle.js.nodes.instrumentation.NodeObjectDescriptor;
import com.oracle.truffle.js.runtime.JSFrameUtil;
import com.oracle.truffle.js.runtime.objects.Undefined;
import java.util.ArrayList;
import java.util.Set;

public final class DeclareTagProvider {
    public static JavaScriptNode createMaterializedFunctionBodyNode(JavaScriptNode body, SourceSection sourceSection, FrameDescriptor frameDescriptor) {
        return new MaterializedFunctionBodyNode(body, sourceSection, frameDescriptor);
    }

    public static JavaScriptNode createMaterializedBlockNode(JavaScriptNode block, FrameDescriptor frameDescriptor, FrameSlot parentSlot, SourceSection sourceSection) {
        return new MaterializedFrameBlockScopeNode(block, frameDescriptor, parentSlot, sourceSection);
    }

    public static boolean isMaterializedFrameProvider(JavaScriptNode node) {
        return node instanceof MaterializedFrameBlockScopeNode || node instanceof MaterializedFunctionBodyNode;
    }

    public static NodeObjectDescriptor createDeclareNodeObject(Object name, Object type) {
        NodeObjectDescriptor descriptor = JSTags.createNodeObjectDescriptor();
        descriptor.addProperty("declarationName", name);
        descriptor.addProperty("declarationType", type);
        return descriptor;
    }

    private DeclareTagProvider() {
    }

    private static JavaScriptNode[] initDeclarations(FrameDescriptor frameDescriptor, SourceSection sourceSection) {
        assert (sourceSection != null);
        if (frameDescriptor != null) {
            ArrayList<FrameSlot> slots = new ArrayList<FrameSlot>();
            for (FrameSlot slot : frameDescriptor.getSlots()) {
                if (JSFrameUtil.isInternal(slot) || JSFrameUtil.isHoistable(slot)) continue;
                slots.add(slot);
            }
            JavaScriptNode[] declarations = new JavaScriptNode[slots.size()];
            for (int i = 0; i < slots.size(); ++i) {
                declarations[i] = new DeclareProviderNode((FrameSlot)slots.get(i));
                declarations[i].setSourceSection(sourceSection);
            }
            return declarations;
        }
        return new JavaScriptNode[0];
    }

    private static class DeclareProviderNode
    extends JavaScriptNode {
        private final FrameSlot slot;

        DeclareProviderNode(FrameSlot slot) {
            this.slot = slot;
        }

        @Override
        public Object execute(VirtualFrame frame) {
            return Undefined.instance;
        }

        @Override
        public boolean hasTag(Class<? extends Tag> tag) {
            if (tag == JSTags.DeclareTag.class) {
                return true;
            }
            return super.hasTag(tag);
        }

        @Override
        public boolean isInstrumentable() {
            return true;
        }

        public Object getNodeObject() {
            String type = JSFrameUtil.isConst(this.slot) ? "const" : (JSFrameUtil.isLet(this.slot) ? "let" : "var");
            return DeclareTagProvider.createDeclareNodeObject(this.slot.getIdentifier(), type);
        }

        @Override
        protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
            return new DeclareProviderNode(this.slot);
        }
    }

    private static class MaterializedFunctionBodyNode
    extends FunctionBodyNode {
        @Node.Children
        private JavaScriptNode[] declarations;
        private final FrameDescriptor frameDescriptor;

        protected MaterializedFunctionBodyNode(JavaScriptNode body, SourceSection sourceSection, FrameDescriptor frameDescriptor) {
            super(body);
            this.frameDescriptor = frameDescriptor;
            this.declarations = DeclareTagProvider.initDeclarations(frameDescriptor, sourceSection);
        }

        @Override
        @ExplodeLoop
        public Object execute(VirtualFrame frame) {
            for (JavaScriptNode declaration : this.declarations) {
                declaration.execute(frame);
            }
            return super.execute(frame);
        }

        @Override
        protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
            return new MaterializedFunctionBodyNode(MaterializedFunctionBodyNode.cloneUninitialized(this.getBody(), materializedTags), this.getSourceSection(), this.frameDescriptor);
        }
    }

    private static class MaterializedFrameBlockScopeNode
    extends BlockScopeNode.FrameBlockScopeNode {
        @Node.Children
        private JavaScriptNode[] declarations;

        protected MaterializedFrameBlockScopeNode(JavaScriptNode block, FrameDescriptor frameDescriptor, FrameSlot parentSlot, SourceSection sourceSection) {
            super(block, frameDescriptor, parentSlot);
            this.declarations = DeclareTagProvider.initDeclarations(frameDescriptor, sourceSection);
        }

        @ExplodeLoop
        private void executeDeclarations(VirtualFrame frame) {
            for (JavaScriptNode declaration : this.declarations) {
                declaration.execute(frame);
            }
        }

        @Override
        public Object execute(VirtualFrame frame) {
            this.executeDeclarations(frame);
            return super.execute(frame);
        }

        @Override
        public void executeVoid(VirtualFrame frame) {
            this.executeDeclarations(frame);
            super.executeVoid(frame);
        }

        @Override
        protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
            return new MaterializedFrameBlockScopeNode(MaterializedFrameBlockScopeNode.cloneUninitialized(this.block, materializedTags), this.frameDescriptor, this.parentSlot, this.getSourceSection());
        }
    }
}

