/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.builtins.JSBuiltinObject;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.JSShape;

public final class JSGlobalObject
extends JSBuiltinObject {
    public static final String CLASS_NAME = "global";
    public static final String EVAL_NAME = "eval";
    public static final JSGlobalObject INSTANCE = new JSGlobalObject();

    private JSGlobalObject() {
    }

    public static DynamicObject create(JSRealm realm, DynamicObject objectPrototype) {
        DynamicObject global;
        CompilerAsserts.neverPartOfCompilation();
        JSContext context = realm.getContext();
        if (context.isMultiContext()) {
            Shape shape = context.makeEmptyShapeWithPrototypeInObject(INSTANCE, JSObject.PROTO_PROPERTY);
            global = JSObject.createInit(shape);
            JSObject.PROTO_PROPERTY.setSafe(global, (Object)objectPrototype, shape);
        } else {
            Shape shape = JSShape.makeUniqueRootWithPrototype(JSObject.LAYOUT, INSTANCE, context, objectPrototype);
            global = JSObject.createInit(shape);
        }
        JSObjectUtil.putDataProperty(context, global, Symbol.SYMBOL_TO_STRING_TAG, CLASS_NAME, JSAttributes.configurableNotEnumerableNotWritable());
        return global;
    }

    public static boolean isJSGlobalObject(Object obj) {
        return JSObject.isDynamicObject(obj) && JSGlobalObject.isJSGlobalObject((DynamicObject)obj);
    }

    public static boolean isJSGlobalObject(DynamicObject obj) {
        return JSGlobalObject.isInstance(obj, (JSClass)INSTANCE);
    }

    @Override
    public String getClassName(DynamicObject object) {
        return CLASS_NAME;
    }
}

