/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.media.tags.internal;

import com.vladsch.flexmark.ast.Link;
import com.vladsch.flexmark.ast.Text;
import com.vladsch.flexmark.ext.media.tags.AudioLink;
import com.vladsch.flexmark.ext.media.tags.EmbedLink;
import com.vladsch.flexmark.ext.media.tags.PictureLink;
import com.vladsch.flexmark.ext.media.tags.VideoLink;
import com.vladsch.flexmark.ext.media.tags.internal.AbstractMediaLink;
import com.vladsch.flexmark.parser.block.NodePostProcessor;
import com.vladsch.flexmark.parser.block.NodePostProcessorFactory;
import com.vladsch.flexmark.util.NodeTracker;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.sequence.BasedSequence;

public class MediaTagsNodePostProcessor
extends NodePostProcessor {
    public MediaTagsNodePostProcessor(DataHolder options) {
    }

    public void process(NodeTracker state, Node node) {
        BasedSequence chars;
        Node previous;
        if (node instanceof Link && (previous = node.getPrevious()) instanceof Text && (chars = previous.getChars()).isContinuedBy(node.getChars())) {
            AbstractMediaLink mediaLink;
            if (chars.endsWith((CharSequence)"!A") && !this.isEscaped(chars, "!A")) {
                mediaLink = new AudioLink((Link)node);
            } else if (chars.endsWith((CharSequence)"!E") && !this.isEscaped(chars, "!E")) {
                mediaLink = new EmbedLink((Link)node);
            } else if (chars.endsWith((CharSequence)"!P") && !this.isEscaped(chars, "!P")) {
                mediaLink = new PictureLink((Link)node);
            } else if (chars.endsWith((CharSequence)"!V") && !this.isEscaped(chars, "!V")) {
                mediaLink = new VideoLink((Link)node);
            } else {
                return;
            }
            mediaLink.takeChildren(node);
            node.unlink();
            state.nodeRemoved(node);
            previous.insertAfter((Node)mediaLink);
            state.nodeAddedWithChildren((Node)mediaLink);
            previous.setChars(chars.subSequence(0, chars.length() - mediaLink.getPrefix().length()));
            if (previous.getChars().length() == 0) {
                previous.unlink();
                state.nodeRemoved(previous);
            }
        }
    }

    private boolean isEscaped(BasedSequence chars, String prefix) {
        int backslashCount = chars.subSequence(0, chars.length() - prefix.length()).countTrailing('\\');
        return (backslashCount & 1) != 0;
    }

    public static class Factory
    extends NodePostProcessorFactory {
        public Factory(DataHolder options) {
            super(false);
            this.addNodes(new Class[]{Link.class});
        }

        public NodePostProcessor create(Document document) {
            return new MediaTagsNodePostProcessor((DataHolder)document);
        }
    }
}

