/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.programs.controllers.ui.composite;

import java.util.ArrayList;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.measure.unit.Unit;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.ui.composites.AbstractEObjectComposite;
import org.eclipse.apogy.common.io.jinput.ApogyCommonIOJInputFactory;
import org.eclipse.apogy.common.io.jinput.EComponent;
import org.eclipse.apogy.common.io.jinput.EVirtualComponent;
import org.eclipse.apogy.common.ui.birt.composites.XYBIRTChartComposite;
import org.eclipse.apogy.core.programs.controllers.AbstractInputConditioning;
import org.eclipse.apogy.core.programs.controllers.ApogyCoreProgramsControllersPackage;
import org.eclipse.apogy.core.programs.controllers.ControllerValueSource;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;

public class InputConditioningTransferFunctionComposite
extends AbstractEObjectComposite<ControllerValueSource, AbstractInputConditioning, AbstractInputConditioning> {
    private XYBIRTChartComposite outputVSInputPlot;
    protected RGB plotBackgroundColor;
    protected RGB plotGridColor;
    protected RGB seriesColor;
    protected EContentAdapter adapter = null;
    private ControllerValueSource previousRootObject;

    public InputConditioningTransferFunctionComposite(Composite parent, int style) {
        super(parent, style, FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ApogyCoreProgramsControllersPackage.Literals.CONTROLLER_VALUE_SOURCE__CONDITIONING}), null);
    }

    protected Composite createContentComposite(Composite parent, int style) {
        Composite top = new Composite(parent, 0);
        top.setLayout((Layout)new GridLayout(1, true));
        this.outputVSInputPlot = new XYBIRTChartComposite(top, style);
        this.outputVSInputPlot.setLayoutData((Object)new GridData(4, 4, true, true));
        this.outputVSInputPlot.setChartTitle("Output vs Input");
        this.outputVSInputPlot.setPlotBackgroundColor(this.getPlotBackgroundColor());
        this.outputVSInputPlot.setPlotGridColor(this.getPlotGridColor());
        this.outputVSInputPlot.setSeriesColor(this.getSeriesColor());
        this.outputVSInputPlot.setXAxisName("Controller Input");
        this.outputVSInputPlot.setXAxisFormatString("0.0");
        this.outputVSInputPlot.setYAxisName(this.getOutputValuesName());
        this.outputVSInputPlot.setYAxisFormatString("0.0");
        top.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (InputConditioningTransferFunctionComposite.this.getRootEObject() != null) {
                    ((ControllerValueSource)InputConditioningTransferFunctionComposite.this.getRootEObject()).eAdapters().remove((Object)InputConditioningTransferFunctionComposite.this.getAdapter());
                }
            }
        });
        return top;
    }

    public RGB getPlotBackgroundColor() {
        if (this.plotBackgroundColor == null) {
            this.plotBackgroundColor = new RGB(0, 0, 0);
        }
        return this.plotBackgroundColor;
    }

    public RGB getPlotGridColor() {
        if (this.plotGridColor == null) {
            this.plotGridColor = new RGB(0, 255, 0);
        }
        return this.plotGridColor;
    }

    public RGB getSeriesColor() {
        if (this.seriesColor == null) {
            this.seriesColor = new RGB(255, 255, 0);
        }
        return this.seriesColor;
    }

    public String getOutputValuesName() {
        Unit<?> outputUnits;
        String valueName = "Command Output";
        if (this.getRootEObject() != null && ((ControllerValueSource)this.getRootEObject()).getBindedEDataTypeArgument() != null) {
            try {
                EParameter eParameter = ((ControllerValueSource)this.getRootEObject()).getBindedEDataTypeArgument().getEParameter();
                valueName = eParameter.getName();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if ((outputUnits = this.getOutputValuesUnits()) != null) {
            valueName = String.valueOf(valueName) + " (" + outputUnits + ")";
        }
        return valueName;
    }

    public Unit<?> getOutputValuesUnits() {
        if (this.getRootEObject() != null && ((ControllerValueSource)this.getRootEObject()).getBindedEDataTypeArgument() != null) {
            try {
                EParameter eParameter = ((ControllerValueSource)this.getRootEObject()).getBindedEDataTypeArgument().getEParameter();
                return ApogyCommonEMFFacade.INSTANCE.getEngineeringUnits((ETypedElement)eParameter);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    protected void rootEObjectChanged(ControllerValueSource rootEObject) {
        if (this.previousRootObject != null) {
            this.previousRootObject.eAdapters().remove((Object)this.getAdapter());
        }
        if (rootEObject != null) {
            this.updateDisplayedValues(rootEObject.getConditioning());
            rootEObject.eAdapters().add((Object)this.getAdapter());
            this.previousRootObject = rootEObject;
        }
    }

    protected void resolvedEObjectChanged(AbstractInputConditioning value) {
        this.updateDisplayedValues(value);
    }

    private void updateDisplayedValues(AbstractInputConditioning abstractInputConditioning) {
        ArrayList<Double> xValues = null;
        ArrayList<Double> yValues = null;
        if (abstractInputConditioning != null) {
            SortedMap<Double, Double> sortedSeriesData = this.getTransferFunctionValues(abstractInputConditioning);
            xValues = new ArrayList();
            xValues.addAll(sortedSeriesData.keySet());
            yValues = new ArrayList();
            yValues.addAll(sortedSeriesData.values());
        } else {
            xValues = new ArrayList<Double>();
            xValues.add(new Double(0.0));
            yValues = new ArrayList<Double>();
            yValues.add(new Double(0.0));
        }
        this.outputVSInputPlot.setYAxisName(this.getOutputValuesName());
        this.outputVSInputPlot.updateValues(xValues, yValues);
    }

    protected SortedMap<Double, Double> getTransferFunctionValues(AbstractInputConditioning abstractInputConditioning) {
        TreeMap<Double, Double> sorted = new TreeMap<Double, Double>();
        EVirtualComponent eVirtualComponent = ApogyCommonIOJInputFactory.eINSTANCE.createEVirtualComponent();
        float inputValue = -1.0f;
        float inputValueIncrement = 0.01f;
        while ((double)inputValue <= 1.0) {
            eVirtualComponent.setCurrentValue(inputValue);
            double outputValue = abstractInputConditioning.conditionInput((EComponent)eVirtualComponent);
            sorted.put(new Double(inputValue), outputValue);
            inputValue += inputValueIncrement;
        }
        return sorted;
    }

    protected EContentAdapter getAdapter() {
        if (this.adapter == null) {
            this.adapter = new EContentAdapter(){

                public void notifyChanged(Notification notification) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (InputConditioningTransferFunctionComposite.this.getRootEObject() != null) {
                                InputConditioningTransferFunctionComposite.this.updateDisplayedValues(((ControllerValueSource)InputConditioningTransferFunctionComposite.this.getRootEObject()).getConditioning());
                            }
                        }
                    });
                    super.notifyChanged(notification);
                }
            };
        }
        return this.adapter;
    }
}

