/*
 * Decompiled with CFR 0.152.
 */
package javax.measure;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.MathContext;
import javax.measure.DecimalMeasure;
import javax.measure.Measurable;
import javax.measure.MeasureFormat;
import javax.measure.VectorMeasure;
import javax.measure.quantity.Quantity;
import javax.measure.unit.CompoundUnit;
import javax.measure.unit.Unit;

public abstract class Measure<V, Q extends Quantity>
implements Measurable<Q>,
Serializable {
    protected Measure() {
    }

    public static <Q extends Quantity> Measure<java.lang.Double, Q> valueOf(double doubleValue, Unit<Q> unit) {
        return new Double<Q>(doubleValue, unit);
    }

    public static <Q extends Quantity> Measure<java.lang.Long, Q> valueOf(long longValue, Unit<Q> unit) {
        return new Long<Q>(longValue, unit);
    }

    public static <Q extends Quantity> Measure<java.lang.Float, Q> valueOf(float floatValue, Unit<Q> unit) {
        return new Float<Q>(floatValue, unit);
    }

    public static <Q extends Quantity> Measure<java.lang.Integer, Q> valueOf(int intValue, Unit<Q> unit) {
        return new Integer<Q>(intValue, unit);
    }

    public abstract V getValue();

    public abstract Unit<Q> getUnit();

    public abstract Measure<V, Q> to(Unit<Q> var1);

    @Override
    public abstract double doubleValue(Unit<Q> var1);

    @Override
    public long longValue(Unit<Q> unit) throws ArithmeticException {
        double doubleValue = this.doubleValue(unit);
        if (java.lang.Double.isNaN(doubleValue) || doubleValue < -9.223372036854776E18 || doubleValue > 9.223372036854776E18) {
            throw new ArithmeticException(String.valueOf(doubleValue) + " " + unit + " cannot be represented as long");
        }
        return Math.round(doubleValue);
    }

    public float floatValue(Unit<Q> unit) {
        return (float)this.doubleValue(unit);
    }

    public int intValue(Unit<Q> unit) {
        long longValue = this.longValue(unit);
        if (longValue > java.lang.Integer.MAX_VALUE || longValue < java.lang.Integer.MIN_VALUE) {
            throw new ArithmeticException("Overflow");
        }
        return (int)longValue;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Measure)) {
            return false;
        }
        Measure that = (Measure)obj;
        return this.getUnit().equals(that.getUnit()) && this.getValue().equals(that.getValue());
    }

    public int hashCode() {
        return this.getUnit().hashCode() + this.getValue().hashCode();
    }

    public String toString() {
        if (this.getUnit() instanceof CompoundUnit) {
            return MeasureFormat.DEFAULT.formatCompound(this.doubleValue(this.getUnit()), this.getUnit(), new StringBuffer(), null).toString();
        }
        return this.getValue() + " " + this.getUnit();
    }

    @Override
    public int compareTo(Measurable<Q> that) {
        return java.lang.Double.compare(this.doubleValue(this.getUnit()), that.doubleValue(this.getUnit()));
    }

    public static <Q extends Quantity> Measure<BigDecimal, Q> valueOf(BigDecimal decimal, Unit<Q> unit) {
        return DecimalMeasure.valueOf(decimal, unit);
    }

    public static <Q extends Quantity> Measure<BigDecimal, Q> valueOf(BigDecimal decimal, Unit<Q> unit, MathContext mathContext) {
        return DecimalMeasure.valueOf(decimal, unit);
    }

    public static <Q extends Quantity> Measure<double[], Q> valueOf(double[] components, Unit<Q> unit) {
        return VectorMeasure.valueOf(components, unit);
    }

    private static final class Double<Q extends Quantity>
    extends Measure<java.lang.Double, Q> {
        private final double _value;
        private final Unit<Q> _unit;
        private static final long serialVersionUID = 1L;

        public Double(double value, Unit<Q> unit) {
            this._value = value;
            this._unit = unit;
        }

        @Override
        public Unit<Q> getUnit() {
            return this._unit;
        }

        @Override
        public java.lang.Double getValue() {
            return this._value;
        }

        @Override
        public Measure<java.lang.Double, Q> to(Unit<Q> unit) {
            if (unit == this._unit || unit.equals(this._unit)) {
                return this;
            }
            return new Double<Q>(this.doubleValue(unit), unit);
        }

        @Override
        public double doubleValue(Unit<Q> unit) {
            if (unit == this._unit || unit.equals(this._unit)) {
                return this._value;
            }
            return this._unit.getConverterTo(unit).convert(this._value);
        }
    }

    private static final class Float<Q extends Quantity>
    extends Measure<java.lang.Float, Q> {
        private final float _value;
        private final Unit<Q> _unit;
        private static final long serialVersionUID = 1L;

        public Float(float value, Unit<Q> unit) {
            this._value = value;
            this._unit = unit;
        }

        @Override
        public Unit<Q> getUnit() {
            return this._unit;
        }

        @Override
        public java.lang.Float getValue() {
            return java.lang.Float.valueOf(this._value);
        }

        @Override
        public Measure<java.lang.Float, Q> to(Unit<Q> unit) {
            if (unit == this._unit || unit.equals(this._unit)) {
                return this;
            }
            return new Float<Q>(this.floatValue(unit), unit);
        }

        @Override
        public double doubleValue(Unit<Q> unit) {
            if (unit == this._unit || unit.equals(this._unit)) {
                return this._value;
            }
            return this._unit.getConverterTo(unit).convert(this._value);
        }
    }

    private static final class Integer<Q extends Quantity>
    extends Measure<java.lang.Integer, Q> {
        private final int _value;
        private final Unit<Q> _unit;
        private static final long serialVersionUID = 1L;

        public Integer(int value, Unit<Q> unit) {
            this._value = value;
            this._unit = unit;
        }

        @Override
        public Unit<Q> getUnit() {
            return this._unit;
        }

        @Override
        public java.lang.Integer getValue() {
            return this._value;
        }

        @Override
        public Measure<java.lang.Integer, Q> to(Unit<Q> unit) {
            if (unit == this._unit || unit.equals(this._unit)) {
                return this;
            }
            return new Integer<Q>(this.intValue(unit), unit);
        }

        @Override
        public double doubleValue(Unit<Q> unit) {
            if (unit == this._unit || unit.equals(this._unit)) {
                return this._value;
            }
            return this._unit.getConverterTo(unit).convert(this._value);
        }

        @Override
        public long longValue(Unit<Q> unit) throws ArithmeticException {
            if (unit == this._unit || unit.equals(this._unit)) {
                return this._value;
            }
            return super.longValue(unit);
        }
    }

    private static final class Long<Q extends Quantity>
    extends Measure<java.lang.Long, Q> {
        private final long _value;
        private final Unit<Q> _unit;
        private static final long serialVersionUID = 1L;

        public Long(long value, Unit<Q> unit) {
            this._value = value;
            this._unit = unit;
        }

        @Override
        public Unit<Q> getUnit() {
            return this._unit;
        }

        @Override
        public java.lang.Long getValue() {
            return this._value;
        }

        @Override
        public Measure<java.lang.Long, Q> to(Unit<Q> unit) {
            if (unit == this._unit || unit.equals(this._unit)) {
                return this;
            }
            return new Long<Q>(this.longValue(unit), unit);
        }

        @Override
        public double doubleValue(Unit<Q> unit) {
            if (unit == this._unit || unit.equals(this._unit)) {
                return this._value;
            }
            return this._unit.getConverterTo(unit).convert(this._value);
        }

        @Override
        public long longValue(Unit<Q> unit) throws ArithmeticException {
            if (unit == this._unit || unit.equals(this._unit)) {
                return this._value;
            }
            return super.longValue(unit);
        }
    }
}

