/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.programs.javascript.ui.composites;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import org.eclipse.apogy.common.emf.transaction.ApogyCommonTransactionFacade;
import org.eclipse.apogy.core.programs.javascript.ApogyCoreJavaScriptProgramsPackage;
import org.eclipse.apogy.core.programs.javascript.JavaScriptProgram;
import org.eclipse.apogy.workspace.ApogyWorkspaceFacade;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.databinding.edit.EMFEditProperties;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaScriptEditorComposite
extends Composite {
    private static final Logger Logger = LoggerFactory.getLogger(JavaScriptEditorComposite.class);
    private JavaScriptProgram javaScriptProgram;
    private Text scriptPath;
    private Text scriptPreview;
    private Button saveButton;
    private Button reloadButton;
    private Button browseButton;
    private DataBindingContext bindingContext;
    private Adapter javaScriptProgramAdapter;

    public JavaScriptEditorComposite(Composite parent, int style) {
        super(parent, style);
    }

    public JavaScriptEditorComposite(Composite parent, int style, final JavaScriptProgram javaScriptProgram) {
        this(parent, style);
        this.setLayout((Layout)new GridLayout(3, false));
        Label scriptPathLabel = new Label((Composite)this, 0);
        scriptPathLabel.setText("Script Path : ");
        this.scriptPath = new Text((Composite)this, 0);
        this.scriptPath.setLayoutData((Object)new GridData(4, 128, true, false));
        this.browseButton = new Button((Composite)this, 8);
        this.browseButton.setText("Browse...");
        this.browseButton.setLayoutData((Object)new GridData(131072, 128, false, false));
        this.browseButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                FileDialog fd = new FileDialog(JavaScriptEditorComposite.this.getShell(), 4096);
                fd.setText("Select Javascript File");
                String relativePath = String.valueOf(ApogyWorkspaceFacade.INSTANCE.getActiveProject().getFullPath().toOSString()) + File.separator + ApogyWorkspaceFacade.INSTANCE.getDefaultProgramsFolderName() + File.separator;
                IPath workspacePath = ResourcesPlugin.getWorkspace().getRoot().getLocation();
                IPath absolutePath = workspacePath.append(relativePath);
                String absolutePathString = absolutePath.toOSString();
                fd.setFilterPath(absolutePathString);
                String[] filterExt = new String[]{"*.js"};
                fd.setFilterExtensions(filterExt);
                String selected = fd.open();
                if (selected != null) {
                    try {
                        String path = String.valueOf(relativePath) + selected.substring(selected.lastIndexOf(File.separator) + 1);
                        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)javaScriptProgram, (EStructuralFeature)ApogyCoreJavaScriptProgramsPackage.Literals.JAVA_SCRIPT_PROGRAM__SCRIPT_PATH, (Object)path, true);
                    }
                    catch (Throwable t) {
                        Logger.error(t.getMessage(), t);
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        this.reloadButton = new Button((Composite)this, 8);
        this.reloadButton.setText("Reload");
        this.reloadButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                try {
                    JavaScriptEditorComposite.this.scriptPreview.setText(JavaScriptEditorComposite.this.load(javaScriptProgram));
                    if (JavaScriptEditorComposite.this.saveButton != null && !JavaScriptEditorComposite.this.saveButton.isDisposed()) {
                        JavaScriptEditorComposite.this.saveButton.setEnabled(false);
                    }
                }
                catch (Exception e) {
                    Logger.error(e.getMessage(), (Throwable)e);
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        this.saveButton = new Button((Composite)this, 8);
        this.saveButton.setEnabled(false);
        this.saveButton.setText("Save");
        this.saveButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                try {
                    JavaScriptEditorComposite.this.save(JavaScriptEditorComposite.this.scriptPreview.getText(), javaScriptProgram);
                    if (JavaScriptEditorComposite.this.saveButton != null && !JavaScriptEditorComposite.this.saveButton.isDisposed()) {
                        JavaScriptEditorComposite.this.saveButton.setEnabled(false);
                    }
                }
                catch (Exception e) {
                    Logger.error(e.getMessage(), (Throwable)e);
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        new Label((Composite)this, 0);
        this.scriptPreview = new Text((Composite)this, 2818);
        this.scriptPreview.setEditable(true);
        GridData gd_scriptPreview = new GridData(4, 128, true, false, 3, 1);
        gd_scriptPreview.minimumHeight = 250;
        gd_scriptPreview.heightHint = 250;
        this.scriptPreview.setLayoutData((Object)gd_scriptPreview);
        try {
            this.scriptPreview.setText(this.load(javaScriptProgram));
        }
        catch (Exception e) {
            Logger.error(e.getMessage(), (Throwable)e);
        }
        this.setJavaScriptProgram(javaScriptProgram);
        this.scriptPreview.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                if (JavaScriptEditorComposite.this.saveButton != null && !JavaScriptEditorComposite.this.saveButton.isDisposed()) {
                    JavaScriptEditorComposite.this.saveButton.setEnabled(true);
                }
                if (JavaScriptEditorComposite.this.reloadButton != null && !JavaScriptEditorComposite.this.reloadButton.isDisposed()) {
                    JavaScriptEditorComposite.this.reloadButton.setEnabled(true);
                }
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                if (javaScriptProgram != null) {
                    javaScriptProgram.eAdapters().remove((Object)JavaScriptEditorComposite.this.getJavaScriptProgramAdapter());
                }
                if (JavaScriptEditorComposite.this.bindingContext != null) {
                    JavaScriptEditorComposite.this.bindingContext.dispose();
                }
            }
        });
    }

    public JavaScriptProgram getJavaScriptProgram() {
        return this.javaScriptProgram;
    }

    public void setJavaScriptProgram(final JavaScriptProgram javaScriptProgram) {
        this.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (JavaScriptEditorComposite.this.bindingContext != null) {
                    JavaScriptEditorComposite.this.bindingContext.dispose();
                    JavaScriptEditorComposite.this.bindingContext = null;
                }
                if (JavaScriptEditorComposite.this.javaScriptProgram != null) {
                    javaScriptProgram.eAdapters().remove((Object)JavaScriptEditorComposite.this.getJavaScriptProgramAdapter());
                    JavaScriptEditorComposite.this.scriptPreview.setText("");
                    JavaScriptEditorComposite.this.saveButton.setEnabled(false);
                    JavaScriptEditorComposite.this.reloadButton.setEnabled(false);
                }
                JavaScriptEditorComposite.this.javaScriptProgram = javaScriptProgram;
                if (javaScriptProgram != null) {
                    JavaScriptEditorComposite.this.bindingContext = JavaScriptEditorComposite.this.customInitDataBindings();
                    javaScriptProgram.eAdapters().add((Object)JavaScriptEditorComposite.this.getJavaScriptProgramAdapter());
                    try {
                        JavaScriptEditorComposite.this.scriptPreview.setText(JavaScriptEditorComposite.this.load(javaScriptProgram));
                        JavaScriptEditorComposite.this.saveButton.setEnabled(false);
                    }
                    catch (Exception e) {
                        Logger.error(e.getMessage(), (Throwable)e);
                    }
                } else {
                    JavaScriptEditorComposite.this.scriptPreview.setText("");
                }
            }
        });
    }

    protected String load(JavaScriptProgram javaScriptProgram) throws Exception {
        IPath absolutePath = ResourcesPlugin.getWorkspace().getRoot().getLocation().append(javaScriptProgram.getScriptPath());
        BufferedReader in = new BufferedReader(new FileReader(absolutePath.toOSString()));
        String line = null;
        StringBuffer sb = new StringBuffer();
        while ((line = in.readLine()) != null) {
            sb.append(String.valueOf(line) + "\n");
        }
        in.close();
        return sb.toString();
    }

    protected void save(String text, JavaScriptProgram javaScriptProgram) throws Exception {
        IPath absolutePath = ResourcesPlugin.getWorkspace().getRoot().getLocation().append(javaScriptProgram.getScriptPath());
        BufferedWriter out = new BufferedWriter(new FileWriter(absolutePath.toOSString()));
        out.write(text);
        out.close();
    }

    protected DataBindingContext customInitDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        IObservableValue observeScriptPath = EMFEditProperties.value((EditingDomain)ApogyCommonTransactionFacade.INSTANCE.getDefaultEditingDomain(), (FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ApogyCoreJavaScriptProgramsPackage.Literals.JAVA_SCRIPT_PROGRAM__SCRIPT_PATH})).observe((Object)this.getJavaScriptProgram());
        ISWTObservableValue observeScriptPathTxt = WidgetProperties.text((int)24).observe((Widget)this.scriptPath);
        bindingContext.bindValue((IObservableValue)observeScriptPathTxt, observeScriptPath, new UpdateValueStrategy(), new UpdateValueStrategy());
        return bindingContext;
    }

    private Adapter getJavaScriptProgramAdapter() {
        if (this.javaScriptProgramAdapter == null) {
            this.javaScriptProgramAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    int featureId;
                    if (msg.getNotifier() instanceof JavaScriptProgram && (featureId = msg.getFeatureID(JavaScriptProgram.class)) == 6) {
                        try {
                            JavaScriptEditorComposite.this.setJavaScriptProgram(JavaScriptEditorComposite.this.getJavaScriptProgram());
                        }
                        catch (Exception e) {
                            Logger.error(e.getMessage(), (Throwable)e);
                        }
                    }
                }
            };
        }
        return this.javaScriptProgramAdapter;
    }
}

