/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.programs.javascript.ui.wizards;

import java.io.File;
import org.eclipse.apogy.common.emf.transaction.ApogyCommonTransactionFacade;
import org.eclipse.apogy.core.programs.javascript.ApogyCoreJavaScriptProgramsPackage;
import org.eclipse.apogy.core.programs.javascript.JavaScriptProgram;
import org.eclipse.apogy.workspace.ApogyWorkspaceFacade;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.databinding.edit.EMFEditProperties;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaScriptWizardPage
extends WizardPage {
    private static final Logger Logger = LoggerFactory.getLogger(JavaScriptWizardPage.class);
    private static final String WIZARD_PAGE_ID = "org.eclipse.apogy.core.programs.javascript.ui.wizards.JavaScriptWizardPage";
    private final JavaScriptProgram javaScriptProgram;
    private Text scriptPath;
    private Button browseButton;
    private DataBindingContext bindingContext;

    public JavaScriptWizardPage(JavaScriptProgram javaScriptProgram) {
        super(WIZARD_PAGE_ID);
        this.javaScriptProgram = javaScriptProgram;
        this.setTitle("Java Script Program.");
        this.setDescription("Select the path to the javascript file.");
        this.validate();
    }

    public void createControl(Composite parent) {
        Composite top = new Composite(parent, 0);
        top.setLayout((Layout)new GridLayout(3, false));
        Label scriptPathLabel = new Label(top, 0);
        scriptPathLabel.setText("Script Path : ");
        this.scriptPath = new Text(top, 0);
        this.scriptPath.setLayoutData((Object)new GridData(4, 128, true, false));
        this.browseButton = new Button(top, 8);
        this.browseButton.setText("Browse...");
        this.browseButton.setLayoutData((Object)new GridData(131072, 128, false, false));
        this.browseButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                FileDialog fd = new FileDialog(JavaScriptWizardPage.this.getShell(), 12288);
                fd.setText("Select Javascript File");
                String relativePath = String.valueOf(ApogyWorkspaceFacade.INSTANCE.getActiveProject().getFullPath().toOSString()) + File.separator + ApogyWorkspaceFacade.INSTANCE.getDefaultProgramsFolderName() + File.separator;
                IPath workspacePath = ResourcesPlugin.getWorkspace().getRoot().getLocation();
                IPath absolutePath = workspacePath.append(relativePath);
                String absolutePathString = absolutePath.toOSString();
                fd.setFilterPath(absolutePathString);
                String[] filterExt = new String[]{"*.js"};
                fd.setFilterExtensions(filterExt);
                String selected = fd.open();
                if (selected != null) {
                    try {
                        String path = String.valueOf(relativePath) + selected.substring(selected.lastIndexOf(File.separator) + 1);
                        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)JavaScriptWizardPage.this.javaScriptProgram, (EStructuralFeature)ApogyCoreJavaScriptProgramsPackage.Literals.JAVA_SCRIPT_PROGRAM__SCRIPT_PATH, (Object)path, true);
                    }
                    catch (Throwable t) {
                        Logger.error(t.getMessage(), t);
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        this.setControl((Control)top);
        this.bindingContext = this.customInitDataBindings();
    }

    public void dispose() {
        if (this.bindingContext != null) {
            this.bindingContext.dispose();
        }
        super.dispose();
    }

    protected void validate() {
        this.setPageComplete(this.getErrorMessage() == null);
    }

    protected DataBindingContext customInitDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        IObservableValue observeScriptPath = EMFEditProperties.value((EditingDomain)ApogyCommonTransactionFacade.INSTANCE.getDefaultEditingDomain(), (FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ApogyCoreJavaScriptProgramsPackage.Literals.JAVA_SCRIPT_PROGRAM__SCRIPT_PATH})).observe((Object)this.javaScriptProgram);
        ISWTObservableValue observeScriptPathTxt = WidgetProperties.text((int)24).observe((Widget)this.scriptPath);
        bindingContext.bindValue((IObservableValue)observeScriptPathTxt, observeScriptPath, new UpdateValueStrategy(), new UpdateValueStrategy());
        return bindingContext;
    }
}

