/**
 * *******************************************************************************
 * Copyright (c) 2018 Agence spatiale canadienne / Canadian Space Agency 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *      Steve Monnier OBEO - Initial API and implementation
 *         
 * SPDX-License-Identifier: EPL-1.0    
 * *******************************************************************************
 */
package org.eclipse.apogy.core.programs.javascript;

import org.eclipse.emf.ecore.EFactory;

/**
 * <!-- begin-user-doc -->
 * The <b>Factory</b> for the model.
 * It provides a create method for each non-abstract class of the model.
 * <!-- end-user-doc -->
 * @see org.eclipse.apogy.core.programs.javascript.ApogyCoreJavaScriptProgramsPackage
 * @generated
 */
public interface ApogyCoreJavaScriptProgramsFactory extends EFactory {
	/**
	 * The singleton instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	ApogyCoreJavaScriptProgramsFactory eINSTANCE = org.eclipse.apogy.core.programs.javascript.impl.ApogyCoreJavaScriptProgramsFactoryImpl.init();

	/**
	 * Returns a new object of class '<em>Apogy Java Script Facade</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Apogy Java Script Facade</em>'.
	 * @generated
	 */
	ApogyJavaScriptFacade createApogyJavaScriptFacade();

	/**
	 * Returns a new object of class '<em>Java Script Program</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Java Script Program</em>'.
	 * @generated
	 */
	JavaScriptProgram createJavaScriptProgram();

	/**
	 * Returns a new object of class '<em>Java Script Program Runtime</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Java Script Program Runtime</em>'.
	 * @generated
	 */
	JavaScriptProgramRuntime createJavaScriptProgramRuntime();

	/**
	 * Returns a new object of class '<em>Java Script Program Factory</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return a new object of class '<em>Java Script Program Factory</em>'.
	 * @generated
	 */
	JavaScriptProgramFactory createJavaScriptProgramFactory();

	/**
	 * Returns the package supported by this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the package supported by this factory.
	 * @generated
	 */
	ApogyCoreJavaScriptProgramsPackage getApogyCoreJavaScriptProgramsPackage();

} //ApogyCoreJavaScriptProgramsFactory
