/**
 * *******************************************************************************
 * Copyright (c) 2018 Agence spatiale canadienne / Canadian Space Agency 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *      Steve Monnier OBEO - Initial API and implementation
 *         
 * SPDX-License-Identifier: EPL-1.0    
 * *******************************************************************************
 */
package org.eclipse.apogy.core.programs.javascript;

import org.eclipse.apogy.core.invocator.InvocatorSession;

import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Apogy Java Script Facade</b></em>'.
 * <!-- end-user-doc -->
 *
 *
 * @see org.eclipse.apogy.core.programs.javascript.ApogyCoreJavaScriptProgramsPackage#getApogyJavaScriptFacade()
 * @model annotation="http://www.eclipse.org/apogy isSingleton='true' hasCustomClass='true'"
 * @generated
 */
public interface ApogyJavaScriptFacade extends EObject {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * *
	 * Create the default Java Script code template. This template includes the required header and main function.
	 * @param session The session in which the script is being defined.
	 * @param javaScriptProgram The JavaScriptProgram for which the script is being created.
	 * <!-- end-model-doc -->
	 * @model unique="false" sessionUnique="false" javaScriptProgramUnique="false"
	 * @generated
	 */
	String createJavaScriptCodeTemplate(InvocatorSession session, JavaScriptProgram javaScriptProgram);

	
    /**
     * Returns a '{@link org.eclipse.apogy.core.programs.javascript.ApogyJavaScriptFacade}' singleton.
     * @generated
     */
    public static ApogyJavaScriptFacade INSTANCE = ApogyCoreJavaScriptProgramsFactory.eINSTANCE.createApogyJavaScriptFacade();
	
} // ApogyJavaScriptFacade
