/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.debug;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.internal.browser.BrowserManager;
import org.eclipse.ui.internal.browser.ExternalBrowserInstance;
import org.eclipse.ui.internal.browser.IBrowserDescriptor;

public class NodeJsBrowserDialog
extends MessageDialog {
    public static final String DEFAULT_URL = "https://codewind.dev";
    final String url;
    final String browserName;

    public NodeJsBrowserDialog(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, int dialogImageType, String[] dialogButtonLabels, int defaultIndex, String url, String browserName) {
        super(parentShell, dialogTitle, dialogTitleImage, dialogMessage, dialogImageType, dialogButtonLabels, defaultIndex);
        this.url = url;
        this.browserName = browserName;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected Control createDialogArea(Composite PARENT) {
        Composite composite = (Composite)super.createDialogArea(PARENT);
        composite.setLayout((Layout)new GridLayout(3, false));
        Text l = new Text(composite, 72);
        l.setText(Messages.NodeJsBrowserDialogPasteMessage);
        l.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        l.setBackground(composite.getBackground());
        l.setForeground(composite.getForeground());
        Text l2 = new Text(composite, 2048);
        GridData gridData = new GridData(4, 0x1000000, true, false, 3, 1);
        gridData.minimumWidth = 500;
        gridData.widthHint = 500;
        l2.setLayoutData((Object)gridData);
        l2.setText(this.url);
        Label emptyLabel = new Label(composite, 0);
        emptyLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        Button button = new Button(composite, 8);
        button.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        button.setText(Messages.NodeJsBrowserDialogCopyToClipboardButton);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Clipboard clipboard = new Clipboard(Display.getDefault());
                String textData = NodeJsBrowserDialog.this.url;
                TextTransfer textTransfer = TextTransfer.getInstance();
                clipboard.setContents(new Object[]{textData}, new Transfer[]{textTransfer});
                clipboard.dispose();
            }
        });
        button = new Button(composite, 8);
        button.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        button.setText(Messages.NodeJsBrowserDialogOpenChromeButton);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NodeJsBrowserDialog.this.launchWebBrowser(NodeJsBrowserDialog.this.browserName, NodeJsBrowserDialog.DEFAULT_URL);
            }
        });
        emptyLabel = new Label(composite, 0);
        emptyLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 3, 1));
        return composite;
    }

    protected boolean isResizable() {
        return true;
    }

    protected void launchWebBrowser(String browserName, String urlStr) {
        Logger.log((String)("Launch web browser " + browserName + " with url: " + this.url));
        URL url = null;
        try {
            url = new URL(urlStr);
        }
        catch (MalformedURLException e1) {
            Logger.logError((String)("Could not create a url for the string: " + urlStr), (Throwable)e1);
            return;
        }
        BrowserManager bm = BrowserManager.getInstance();
        List browserList = bm.getWebBrowsers();
        IBrowserDescriptor foundBrowser = null;
        int size = browserList.size();
        for (int i = 0; i < size; ++i) {
            String name;
            IBrowserDescriptor browserDescriptor = (IBrowserDescriptor)browserList.get(i);
            if (browserDescriptor == null || (name = browserDescriptor.getName()) == null || !name.equals(browserName)) continue;
            foundBrowser = browserDescriptor;
            break;
        }
        if (foundBrowser != null) {
            ExternalBrowserInstance ebi = new ExternalBrowserInstance("Node.js Debugger", foundBrowser);
            try {
                ebi.openURL(url);
            }
            catch (Exception e) {
                Logger.logError((String)"Could not launch the browser for Node.js debugging", (Throwable)e);
            }
        }
    }
}

