/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.drift.internal.frontend;

import com.sun.prism.ResourceFactory;
import java.nio.ByteBuffer;
import org.eclipse.fx.drift.Vec2i;
import org.eclipse.fx.drift.internal.GL;
import org.eclipse.fx.drift.internal.QuantumHelper;
import org.eclipse.fx.drift.internal.SYS;
import org.eclipse.fx.drift.internal.common.IOSurfaceImageData;
import org.eclipse.fx.drift.internal.frontend.AFxImage;
import org.eclipse.fx.drift.internal.jni.MemoryStack;
import org.eclipse.fx.drift.internal.jni.macos.MacOS;
import org.eclipse.fx.drift.internal.prism.Prism;
import org.eclipse.fx.drift.internal.prism.PrismES2;

public class IOSurfaceFxImage
extends AFxImage<IOSurfaceImageData> {
    private ResourceFactory rf;
    MacOS.IOSurfaceRef ioSurface;
    int ioSurfaceTexture;
    private int readFbo;
    private int drawFbo;

    public IOSurfaceFxImage(IOSurfaceImageData data) {
        super(data);
    }

    @Override
    public void allocate(ResourceFactory rf) throws Exception {
        this.rf = rf;
        super.allocate(rf);
        QuantumHelper.syncExecute(rf, () -> {
            this.ioSurface = MacOS.IOSurfaceLookup(((IOSurfaceImageData)this.data).ioSurfaceID);
            this.ioSurfaceTexture = GL.glGenTexture();
            GL.glBindTexture(34037, this.ioSurfaceTexture);
            MacOS.CGLContextObj cglContext = MacOS.CGLGetCurrentContext();
            MacOS.CGLError error = MacOS.CGLTexImageIOSurface2D(cglContext, 34037, 6408, ((IOSurfaceImageData)this.data).size.x, ((IOSurfaceImageData)this.data).size.y, 32993, 33639, this.ioSurface, 0);
            if (error != MacOS.CGLError.kCGLNoError) {
                throw new RuntimeException("Could not connect to IOSurface " + ((IOSurfaceImageData)this.data).ioSurfaceID);
            }
            GL.glBindTexture(34037, 0);
            this.readFbo = GL.glGenFramebuffer();
            this.drawFbo = GL.glGenFramebuffer();
            GL.glBindFramebuffer(36008, this.readFbo);
            GL.glFramebufferTexture(36008, 36064, this.ioSurfaceTexture, 0);
            GL.glBindFramebuffer(36008, 0);
            GL.glBindFramebuffer(36009, this.drawFbo);
            GL.glFramebufferTexture(36009, 36064, PrismES2.getTextureName(this.getTexture()), 0);
            GL.glBindFramebuffer(36009, 0);
        });
    }

    @Override
    public void release() {
        super.release();
        QuantumHelper.syncExecute(this.rf, () -> {
            GL.glDeleteTexture(this.ioSurfaceTexture);
            MacOS.CFRelease(this.ioSurface);
            GL.glDeleteFramebuffer(this.readFbo);
            GL.glDeleteFramebuffer(this.drawFbo);
        });
    }

    private void blitFramebuffer() {
        GL.glBindFramebuffer(36008, this.readFbo);
        GL.glBindFramebuffer(36009, this.drawFbo);
        GL.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        GL.glClear(16384);
        GL.glBlitFramebuffer(0, 0, ((IOSurfaceImageData)this.data).size.x, ((IOSurfaceImageData)this.data).size.y, 0, 0, ((IOSurfaceImageData)this.data).size.x, ((IOSurfaceImageData)this.data).size.y, 16384, 9729);
        GL.glBindFramebuffer(36008, 0);
        GL.glBindFramebuffer(36009, 0);
    }

    private void copyTextureFramebuffer(int sourceTex, int targetTex, Vec2i size) {
        int sourceFbo = GL.glGenFramebuffer();
        int targetFbo = GL.glGenFramebuffer();
        GL.glBindFramebuffer(36008, sourceFbo);
        GL.glFramebufferTexture(36008, 36064, sourceTex, 0);
        GL.glBindFramebuffer(36009, targetFbo);
        GL.glFramebufferTexture(36009, 36064, targetTex, 0);
        GL.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        GL.glClear(16384);
        GL.glBlitFramebuffer(0, 0, size.x, size.y, 0, 0, size.x, size.y, 16384, 9729);
        GL.glFinish();
        GL.glDeleteFramebuffer(sourceFbo);
        GL.glDeleteFramebuffer(targetFbo);
    }

    public static void dumpIOSurface(long ioSurfaceID, Vec2i size) {
        System.err.println("dumpIOSurface " + ioSurfaceID);
        int tempTexture = GL.glGenTexture();
        MacOS.CGLContextObj cglContext = MacOS.CGLGetCurrentContext();
        System.err.println("GOT CONTEXT " + cglContext);
        MacOS.IOSurfaceRef ioSurface = MacOS.IOSurfaceLookup(ioSurfaceID);
        System.err.println("GOT IOSURFACE " + ioSurface);
        GL.glBindTexture(34037, tempTexture);
        MacOS.CGLError success = MacOS.CGLTexImageIOSurface2D(cglContext, 34037, 6408, size.x, size.y, 32993, 33639, ioSurface, 0);
        GL.glBindTexture(34037, 0);
        System.err.println("mount success_: " + (Object)((Object)success));
        MacOS.IOSurfaceLock(ioSurface);
        int memSize = size.x * size.y * 4;
        ByteBuffer buf = ByteBuffer.allocateDirect(memSize);
        buf.put((byte)1);
        buf.put((byte)1);
        buf.put((byte)1);
        buf.put((byte)1);
        buf.clear();
        long memPointer = MemoryStack.getBufferAddress(buf);
        IOSurfaceFxImage.downloadToMemorySimple(34037, tempTexture, memPointer);
        byte r = buf.get();
        byte g = buf.get();
        byte b = buf.get();
        byte a = buf.get();
        System.err.println("First Pixel: " + r + " / " + g + " / " + b + " / " + a);
        MacOS.IOSurfaceUnlock(ioSurface);
        GL.glDeleteTexture(tempTexture);
        MacOS.CFRelease(ioSurface);
    }

    public static void dumpGLTexture(int name, Vec2i size) {
        System.err.println("dumpGLTexture " + name);
        int memSize = size.x * size.y * 4;
        ByteBuffer buf = ByteBuffer.allocateDirect(memSize);
        buf.put((byte)1);
        buf.put((byte)1);
        buf.put((byte)1);
        buf.put((byte)1);
        buf.clear();
        long memPointer = MemoryStack.getBufferAddress(buf);
        IOSurfaceFxImage.downloadToMemorySimple(3553, name, memPointer);
        byte r = buf.get();
        byte g = buf.get();
        byte b = buf.get();
        byte a = buf.get();
        System.err.println("First Pixel: " + r + " / " + g + " / " + b + " / " + a);
    }

    @Override
    public void update() {
        QuantumHelper.syncExecute(this.rf, () -> {
            GL.glBindTexture(34037, 0);
            GL.glBindFramebuffer(36160, 0);
            this.blitFramebuffer();
            GL.glFinish();
        });
    }

    private static void downloadToMemorySimple(int target, int tex, long pPixels) {
        int format = Prism.isD3D() ? 32993 : 6408;
        GL.glBindTexture(target, tex);
        GL.glGetTexImage(target, 0, format, 33639, pPixels);
        GL.glBindTexture(target, 0);
        System.out.println("*downloaded " + tex + " => 0x" + Long.toHexString(pPixels));
        System.out.flush();
    }

    private static void downloadToMemoryBuf(int tex, int size, long pPixels) {
        int buf = GL.glGenBuffer();
        GL.glBindBuffer(35051, buf);
        GL.glBufferData(35051, size, 0L, 35045);
        int format = 6408;
        GL.glBindTexture(3553, tex);
        GL.glGetTexImage(3553, 0, format, 33639, 0L);
        GL.glBindTexture(3553, 0);
        long glBuf = GL.glMapBuffer(35051, 35000);
        SYS.memcpy(pPixels, glBuf, size);
        GL.glUnmapBuffer(35051);
        GL.glBindBuffer(35051, 0);
        GL.glDeleteBuffer(buf);
    }
}

