/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.code.editor.configuration.gson;

import com.google.gson.JsonObject;
import org.eclipse.fx.code.editor.configuration.Check;
import org.eclipse.fx.code.editor.configuration.Condition;
import org.eclipse.fx.code.editor.configuration.EditorGModel;
import org.eclipse.fx.code.editor.configuration.PartitionRule;
import org.eclipse.fx.code.editor.configuration.gson.GsonBase;
import org.eclipse.fx.code.editor.configuration.gson.GsonElementFactory;

public final class GsonPartitionRuleImpl
implements GsonBase,
PartitionRule {
    private final Check check;
    private final Condition condition;

    public GsonPartitionRuleImpl(JsonObject jsonObject) {
        this.check = jsonObject.has("check") ? GsonElementFactory.createCheck(jsonObject.getAsJsonObject("check")) : null;
        this.condition = jsonObject.has("condition") ? GsonElementFactory.createCondition(jsonObject.getAsJsonObject("condition")) : null;
    }

    public GsonPartitionRuleImpl(Check check, Condition condition) {
        this.check = check;
        this.condition = condition;
    }

    @Override
    public JsonObject toJSONObject() {
        JsonObject o = new JsonObject();
        o.addProperty("$gtype", "PartitionRule");
        o.add("check", this.getCheck() == null ? null : ((GsonBase)((Object)this.getCheck())).toJSONObject());
        o.add("condition", this.getCondition() == null ? null : ((GsonBase)((Object)this.getCondition())).toJSONObject());
        return o;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode()) + " { check : " + (this.check == null ? null : this.check.getClass().getSimpleName() + "@" + Integer.toHexString(this.check.hashCode())) + ", condition : " + (this.condition == null ? null : this.condition.getClass().getSimpleName() + "@" + Integer.toHexString(this.condition.hashCode())) + " }";
    }

    @Override
    public Check getCheck() {
        return this.check;
    }

    @Override
    public Condition getCondition() {
        return this.condition;
    }

    public static class Builder
    implements PartitionRule.Builder {
        private final EditorGModel instance;
        private Check check;
        private Condition condition;

        public Builder(EditorGModel instance) {
            this.instance = instance;
        }

        @Override
        public Builder check(Check check) {
            this.check = check;
            return this;
        }

        @Override
        public Builder condition(Condition condition) {
            this.condition = condition;
            return this;
        }

        @Override
        public PartitionRule build() {
            return new GsonPartitionRuleImpl(this.check, this.condition);
        }
    }
}

