package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.mandas.docker.Nullable;

/**
 * Immutable implementation of {@link SwarmInit}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSwarmInit.builder()}.
 */
@SuppressWarnings({"all"})
final class ImmutableSwarmInit implements SwarmInit {
  private final String listenAddr;
  private final String advertiseAddr;
  private final @Nullable Boolean forceNewCluster;
  private final @Nullable SwarmSpec swarmSpec;

  private ImmutableSwarmInit(
      String listenAddr,
      String advertiseAddr,
      @Nullable Boolean forceNewCluster,
      @Nullable SwarmSpec swarmSpec) {
    this.listenAddr = listenAddr;
    this.advertiseAddr = advertiseAddr;
    this.forceNewCluster = forceNewCluster;
    this.swarmSpec = swarmSpec;
  }

  /**
   * @return The value of the {@code listenAddr} attribute
   */
  @JsonProperty("ListenAddr")
  @Override
  public String listenAddr() {
    return listenAddr;
  }

  /**
   * @return The value of the {@code advertiseAddr} attribute
   */
  @JsonProperty("AdvertiseAddr")
  @Override
  public String advertiseAddr() {
    return advertiseAddr;
  }

  /**
   * @return The value of the {@code forceNewCluster} attribute
   */
  @JsonProperty("ForceNewCluster")
  @Override
  public @Nullable Boolean forceNewCluster() {
    return forceNewCluster;
  }

  /**
   * @return The value of the {@code swarmSpec} attribute
   */
  @JsonProperty("Spec")
  @Override
  public @Nullable SwarmSpec swarmSpec() {
    return swarmSpec;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SwarmInit#listenAddr() listenAddr} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for listenAddr
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSwarmInit withListenAddr(String value) {
    String newValue = Objects.requireNonNull(value, "listenAddr");
    if (this.listenAddr.equals(newValue)) return this;
    return new ImmutableSwarmInit(newValue, this.advertiseAddr, this.forceNewCluster, this.swarmSpec);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SwarmInit#advertiseAddr() advertiseAddr} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for advertiseAddr
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSwarmInit withAdvertiseAddr(String value) {
    String newValue = Objects.requireNonNull(value, "advertiseAddr");
    if (this.advertiseAddr.equals(newValue)) return this;
    return new ImmutableSwarmInit(this.listenAddr, newValue, this.forceNewCluster, this.swarmSpec);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SwarmInit#forceNewCluster() forceNewCluster} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for forceNewCluster (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSwarmInit withForceNewCluster(@Nullable Boolean value) {
    if (Objects.equals(this.forceNewCluster, value)) return this;
    return new ImmutableSwarmInit(this.listenAddr, this.advertiseAddr, value, this.swarmSpec);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SwarmInit#swarmSpec() swarmSpec} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for swarmSpec (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSwarmInit withSwarmSpec(@Nullable SwarmSpec value) {
    if (this.swarmSpec == value) return this;
    return new ImmutableSwarmInit(this.listenAddr, this.advertiseAddr, this.forceNewCluster, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSwarmInit} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSwarmInit
        && equalTo(0, (ImmutableSwarmInit) another);
  }

  private boolean equalTo(int synthetic, ImmutableSwarmInit another) {
    return listenAddr.equals(another.listenAddr)
        && advertiseAddr.equals(another.advertiseAddr)
        && Objects.equals(forceNewCluster, another.forceNewCluster)
        && Objects.equals(swarmSpec, another.swarmSpec);
  }

  /**
   * Computes a hash code from attributes: {@code listenAddr}, {@code advertiseAddr}, {@code forceNewCluster}, {@code swarmSpec}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + listenAddr.hashCode();
    h += (h << 5) + advertiseAddr.hashCode();
    h += (h << 5) + Objects.hashCode(forceNewCluster);
    h += (h << 5) + Objects.hashCode(swarmSpec);
    return h;
  }

  /**
   * Prints the immutable value {@code SwarmInit} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "SwarmInit{"
        + "listenAddr=" + listenAddr
        + ", advertiseAddr=" + advertiseAddr
        + ", forceNewCluster=" + forceNewCluster
        + ", swarmSpec=" + swarmSpec
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link SwarmInit} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SwarmInit instance
   */
  public static ImmutableSwarmInit copyOf(SwarmInit instance) {
    if (instance instanceof ImmutableSwarmInit) {
      return (ImmutableSwarmInit) instance;
    }
    return ImmutableSwarmInit.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSwarmInit ImmutableSwarmInit}.
   * <pre>
   * ImmutableSwarmInit.builder()
   *    .listenAddr(String) // required {@link SwarmInit#listenAddr() listenAddr}
   *    .advertiseAddr(String) // required {@link SwarmInit#advertiseAddr() advertiseAddr}
   *    .forceNewCluster(Boolean | null) // nullable {@link SwarmInit#forceNewCluster() forceNewCluster}
   *    .swarmSpec(org.mandas.docker.client.messages.swarm.SwarmSpec | null) // nullable {@link SwarmInit#swarmSpec() swarmSpec}
   *    .build();
   * </pre>
   * @return A new ImmutableSwarmInit builder
   */
  public static ImmutableSwarmInit.Builder builder() {
    return new ImmutableSwarmInit.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSwarmInit ImmutableSwarmInit}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  static final class Builder implements SwarmInit.Builder {
    private static final long INIT_BIT_LISTEN_ADDR = 0x1L;
    private static final long INIT_BIT_ADVERTISE_ADDR = 0x2L;
    private long initBits = 0x3L;

    private String listenAddr;
    private String advertiseAddr;
    private Boolean forceNewCluster;
    private SwarmSpec swarmSpec;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SwarmInit} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SwarmInit instance) {
      Objects.requireNonNull(instance, "instance");
      this.listenAddr(instance.listenAddr());
      this.advertiseAddr(instance.advertiseAddr());
      @Nullable Boolean forceNewClusterValue = instance.forceNewCluster();
      if (forceNewClusterValue != null) {
        forceNewCluster(forceNewClusterValue);
      }
      @Nullable SwarmSpec swarmSpecValue = instance.swarmSpec();
      if (swarmSpecValue != null) {
        swarmSpec(swarmSpecValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link SwarmInit#listenAddr() listenAddr} attribute.
     * @param listenAddr The value for listenAddr 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("ListenAddr")
    public final Builder listenAddr(String listenAddr) {
      this.listenAddr = Objects.requireNonNull(listenAddr, "listenAddr");
      initBits &= ~INIT_BIT_LISTEN_ADDR;
      return this;
    }

    /**
     * Initializes the value for the {@link SwarmInit#advertiseAddr() advertiseAddr} attribute.
     * @param advertiseAddr The value for advertiseAddr 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("AdvertiseAddr")
    public final Builder advertiseAddr(String advertiseAddr) {
      this.advertiseAddr = Objects.requireNonNull(advertiseAddr, "advertiseAddr");
      initBits &= ~INIT_BIT_ADVERTISE_ADDR;
      return this;
    }

    /**
     * Initializes the value for the {@link SwarmInit#forceNewCluster() forceNewCluster} attribute.
     * @param forceNewCluster The value for forceNewCluster (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("ForceNewCluster")
    public final Builder forceNewCluster(@Nullable Boolean forceNewCluster) {
      this.forceNewCluster = forceNewCluster;
      return this;
    }

    /**
     * Initializes the value for the {@link SwarmInit#swarmSpec() swarmSpec} attribute.
     * @param swarmSpec The value for swarmSpec (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("Spec")
    public final Builder swarmSpec(@Nullable SwarmSpec swarmSpec) {
      this.swarmSpec = swarmSpec;
      return this;
    }

    /**
     * Builds a new {@link ImmutableSwarmInit ImmutableSwarmInit}.
     * @return An immutable instance of SwarmInit
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSwarmInit build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableSwarmInit(listenAddr, advertiseAddr, forceNewCluster, swarmSpec);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_LISTEN_ADDR) != 0) attributes.add("listenAddr");
      if ((initBits & INIT_BIT_ADVERTISE_ADDR) != 0) attributes.add("advertiseAddr");
      return "Cannot build SwarmInit, some of required attributes are not set " + attributes;
    }
  }
}
