/*******************************************************************************
 * Copyright (c) 2008 - 2010 Ecliptical Software Inc. and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Ecliptical Software Inc. - initial API and implementation
 *******************************************************************************/
package org.eclipse.emf.mint.internal.genmodel;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelPackage;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.mint.IItemJavaElementDescriptor;

public class GenClassItemProvider extends GenClassifierItemProvider {

	protected static final List<EReference> GROUP_REFERENCES = appendList(
			GenClassifierItemProvider.GROUP_REFERENCES,
			GenModelPackage.Literals.GEN_CLASS__ECORE_CLASS);

	protected static final List<EStructuralFeature> OBSERVED_FEATURES = Arrays
			.asList(
					(EStructuralFeature) GenModelPackage.Literals.GEN_CLASS__PROVIDER,
					GenModelPackage.Literals.GEN_CLASS__DYNAMIC);

	public GenClassItemProvider(
			GenModelJavaElementSourceContributor sourceContributor) {
		super(sourceContributor);
	}

	@Override
	public List<IItemJavaElementDescriptor> getJavaElementDescriptors(
			Object object) {
		GenClass genClass = (GenClass) object;
		if (!isFullyResolved(genClass))
			return Collections.emptyList();

		UniqueEList<IItemJavaElementDescriptor> list = new UniqueEList<IItemJavaElementDescriptor>();

		GenModel genModel = genClass.getGenModel();
		String modelDir = genModel.getModelDirectory();

		addType(modelDir, genClass.getQualifiedInterfaceName(), CAT_INTERFACE,
				Messages.GenClassItemProvider_GeneratedInterfaceLabel,
				Messages.GenClassItemProvider_GeneratedInterfaceDescription,
				GenModelPackage.Literals.GEN_CLASS__ECORE_CLASS, true, list);

		if (!genClass.isDynamic() && !genClass.isInterface())
			addType(modelDir, genClass.getQualifiedClassName(),
					CAT_IMPLEMENTATION,
					Messages.GenClassItemProvider_GeneratedClassLabel,
					Messages.GenClassItemProvider_GeneratedClassDescription,
					GenModelPackage.Literals.GEN_CLASS__ECORE_CLASS, true, list);

		if (!genClass.isDynamic() && !genClass.isInterface())
			addType(
					genModel.getEditDirectory(),
					genClass.getQualifiedProviderClassName(),
					CAT_PROVIDER,
					Messages.GenClassItemProvider_GeneratedItemProviderLabel,
					Messages.GenClassItemProvider_GeneratedItemProviderDescription,
					GenModelPackage.Literals.GEN_CLASS__PROVIDER, true, list);

		addType(genModel.getTestsDirectory(), genClass
				.getQualifiedTestCaseClassName(), CAT_TEST,
				Messages.GenClassItemProvider_GeneratedTestCaseLabel,
				Messages.GenClassItemProvider_GeneratedTestCaseDescription,
				null, true, list);

		addType(genModel.getEditDirectory(),
				getProviderBaseClassName(genClass), CAT_PROVIDER,
				Messages.GenClassItemProvider_GetProviderBaseLabel, Messages.GenClassItemProvider_GetProviderBaseDescription, null, list);

		return list;
	}

	private String getProviderBaseClassName(GenClass genClass) {
		// get name w/out using the import manager, see bug 234063
		GenClass baseClass = genClass.getProviderExtendsGenClass();
		return baseClass != null ? baseClass.getQualifiedProviderClassName()
				: isBlank(genClass.getGenModel().getProviderRootExtendsClass()) ? null
						: genClass.getGenModel().getProviderRootExtendsClass();
	}

	@Override
	protected GroupReferenceGenModelSwitch createGroupReferenceGenModelSwitch() {
		return new GenClassifierGroupReferenceGenModelSwitch() {
			@Override
			public List<EReference> caseGenClass(GenClass object) {
				return GROUP_REFERENCES;
			}
		};
	}

	@Override
	protected ObservedFeatureGenModelSwitch createObservedFeatureGenModelSwitch() {
		return new GenClassifierObservedFeatureGenModelSwitch() {
			@Override
			public List<EStructuralFeature> caseGenClass(GenClass object) {
				return OBSERVED_FEATURES;
			}
		};
	}
}
