/*******************************************************************************
 * Copyright (c) 2008, 2009 Ecliptical Software Inc. and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Ecliptical Software Inc. - initial API and implementation
 *******************************************************************************/
package org.eclipse.emf.mint.internal.genmodel;

import java.util.Arrays;
import java.util.List;

import org.eclipse.emf.codegen.ecore.genmodel.GenClassifier;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelPackage;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.codegen.ecore.genmodel.GenTypeParameter;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypeParameter;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.mint.IItemJavaElementSource;

public abstract class GenClassifierItemProvider extends
		JavaElementItemProviderAdapter implements IItemJavaElementSource {

	protected static final List<EReference> GROUP_REFERENCES = Arrays.asList(
			GenModelPackage.Literals.GEN_CLASSIFIER__GEN_PACKAGE,
			GenModelPackage.Literals.GEN_CLASSIFIER__GEN_TYPE_PARAMETERS);

	protected static final List<EReference> GROUP_REFERENCES__GEN_PACKAGE = Arrays
			.asList(GenModelPackage.Literals.GEN_PACKAGE__GEN_MODEL,
					GenModelPackage.Literals.GEN_PACKAGE__ECORE_PACKAGE);

	protected static final List<EReference> GROUP_REFERENCES__GEN_TYPE_PARAMETERS = Arrays
			.asList(GenModelPackage.Literals.GEN_TYPE_PARAMETER__ECORE_TYPE_PARAMETER);

	protected static final List<EStructuralFeature> OBSERVED_FEATURES__GEN_PACKAGE = Arrays
			.asList(
					(EStructuralFeature) GenModelPackage.Literals.GEN_PACKAGE__PREFIX,
					GenModelPackage.Literals.GEN_PACKAGE__BASE_PACKAGE,
					GenModelPackage.Literals.GEN_PACKAGE__INTERFACE_PACKAGE_SUFFIX,
					GenModelPackage.Literals.GEN_PACKAGE__META_DATA_PACKAGE_SUFFIX,
					GenModelPackage.Literals.GEN_PACKAGE__CLASS_PACKAGE_SUFFIX,
					GenModelPackage.Literals.GEN_PACKAGE__UTILITY_PACKAGE_SUFFIX,
					GenModelPackage.Literals.GEN_PACKAGE__PROVIDER_PACKAGE_SUFFIX,
					GenModelPackage.Literals.GEN_PACKAGE__PRESENTATION_PACKAGE_SUFFIX,
					GenModelPackage.Literals.GEN_PACKAGE__TESTS_PACKAGE_SUFFIX,
					GenModelPackage.Literals.GEN_PACKAGE__LITERALS_INTERFACE);

	protected static final List<EStructuralFeature> OBSERVED_FEATURES__GEN_PACKAGE__GEN_MODEL = Arrays
			.asList(
					(EStructuralFeature) GenModelPackage.Literals.GEN_MODEL__MODEL_DIRECTORY,
					GenModelPackage.Literals.GEN_MODEL__EDIT_DIRECTORY,
					GenModelPackage.Literals.GEN_MODEL__EDITOR_DIRECTORY,
					GenModelPackage.Literals.GEN_MODEL__TESTS_DIRECTORY);

	protected static final List<EStructuralFeature> OBSERVED_FEATURES__ECORE_CLASSIFIER = Arrays
			.asList((EStructuralFeature) EcorePackage.Literals.ENAMED_ELEMENT__NAME);

	protected static final List<EStructuralFeature> OBSERVED_FEATURES__GEN_PACKAGE__ECORE_PACKAGE = Arrays
			.asList((EStructuralFeature) EcorePackage.Literals.ENAMED_ELEMENT__NAME);

	protected static final List<EStructuralFeature> OBSERVED_FEATURES__GEN_TYPE_PARAMETERS__ECORE_TYPE_PARAMETER = Arrays
			.asList((EStructuralFeature) EcorePackage.Literals.ENAMED_ELEMENT__NAME);

	public GenClassifierItemProvider(GenModelJavaElementSourceContributor sourceContributor) {
		super(sourceContributor);
	}

	@Override
	protected GroupReferenceGenModelSwitch createGroupReferenceGenModelSwitch() {
		return new GenClassifierGroupReferenceGenModelSwitch();
	}

	@Override
	protected ObservedFeatureGenModelSwitch createObservedFeatureGenModelSwitch() {
		return new GenClassifierObservedFeatureGenModelSwitch();
	}

	protected static class GenClassifierGroupReferenceGenModelSwitch extends
			GroupReferenceGenModelSwitch {

		@Override
		public List<EReference> caseGenClassifier(GenClassifier object) {
			return GROUP_REFERENCES;
		}

		@Override
		public List<EReference> caseGenPackage(GenPackage object) {
			return GROUP_REFERENCES__GEN_PACKAGE;
		}

		@Override
		public List<EReference> caseGenTypeParameter(GenTypeParameter object) {
			return GROUP_REFERENCES__GEN_TYPE_PARAMETERS;
		}
	}

	protected static class GenClassifierObservedFeatureGenModelSwitch extends
			ObservedFeatureGenModelSwitch {

		@Override
		public List<EStructuralFeature> caseGenPackage(GenPackage object) {
			return OBSERVED_FEATURES__GEN_PACKAGE;
		}

		@Override
		public List<EStructuralFeature> caseGenModel(GenModel object) {
			return OBSERVED_FEATURES__GEN_PACKAGE__GEN_MODEL;
		}

		@Override
		protected ObservedFeatureEcoreSwitch createObservedFeatureEcoreSwitch() {
			return new GenClassifierObservedFeatureEcoreSwitch();
		}
	}

	protected static class GenClassifierObservedFeatureEcoreSwitch extends
			ObservedFeatureEcoreSwitch {

		@Override
		public List<EStructuralFeature> caseEClassifier(EClassifier object) {
			return OBSERVED_FEATURES__ECORE_CLASSIFIER;
		}

		@Override
		public List<EStructuralFeature> caseEPackage(EPackage object) {
			return OBSERVED_FEATURES__GEN_PACKAGE__ECORE_PACKAGE;
		}

		@Override
		public List<EStructuralFeature> caseETypeParameter(ETypeParameter object) {
			return OBSERVED_FEATURES__GEN_TYPE_PARAMETERS__ECORE_TYPE_PARAMETER;
		}
	}
}
