/**
 * <copyright> 
 * 
 * Copyright (c) 2004-2005 IBM Corporation and others. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License - v 1.0 
 * which accompanies this distribution, and is available at 
 * http://opensource.org/licenses/eclipse-1.0.txt 
 * 
 * Contributors: 
 *   IBM - Initial API and implementation 
 * 
 * </copyright> 
 * 
 * $Id: OWLOntologyGraph.java,v 1.1 2007/03/18 09:07:04 lzhang Exp $
 */

package org.eclipse.eodm.owl.resource.parser.impl;

import org.eclipse.eodm.owl.owlbase.OWLGraph;
import org.eclipse.eodm.owl.owlbase.OWLOntology;
import org.eclipse.eodm.rdf.rdfweb.Document;

/**
 * 
 * OWLOntologyGraph The output results obtained from input OWL documents. It
 * includes a document a graph and an ontology
 */
public class OWLOntologyGraph {

    private Document document;

    private OWLGraph graph;

    private OWLOntology ontology;

    public OWLOntologyGraph() {
    }

    /**
     * Generate an ontology graph
     * 
     * @param doc
     *            EODM document generated from the input OWL files
     * @param g
     *            EODM graph generated from the input OWL files
     * @param onto
     *            EODM ontology generated from the input OWL files
     */
    public OWLOntologyGraph(Document doc, OWLGraph g, OWLOntology onto) {
        document = doc;
        graph = g;
        ontology = onto;
    }

    /**
     * Set EODM document
     * 
     * @param doc
     *            EODM document
     */
    public void setDocument(Document doc) {
        document = doc;
    }

    /**
     * Set EODM graph
     * 
     * @param g
     *            EODM document
     */
    public void setgraph(OWLGraph g) {
        graph = g;
    }

    /**
     * Set EODM Ontology
     * 
     * @param onto
     *            EODM ontology
     */
    public void setOntology(OWLOntology onto) {
        ontology = onto;
    }

    /**
     * Get EODM document
     * 
     * @return EODM document
     */
    public Document getDocument() {
        return document;
    }

    /**
     * Get EODM graph
     * 
     * @return EODM graph
     */
    public OWLGraph getgraph() {
        return graph;
    }

    /**
     * Get EODM ontology
     * 
     * @return EODM ontology
     */
    public OWLOntology getOntology() {
        return ontology;
    }
}
