/**
 * <copyright> 
 * 
 * Copyright (c) 2004-2005 IBM Corporation and others. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License - v 1.0 
 * which accompanies this distribution, and is available at 
 * http://opensource.org/licenses/eclipse-1.0.txt 
 * 
 * Contributors: 
 *   IBM - Initial API and implementation 
 * 
 * </copyright> 
 * 
 * $Id: RDFXMLParser.java,v 1.2 2007/03/18 08:39:03 lzhang Exp $
 */

package org.eclipse.eodm.rdf.resource.parser;

import org.eclipse.eodm.rdf.resource.parser.exception.ParserException;
import org.eclipse.eodm.rdf.resource.parser.exception.ParserIOException;
import org.xml.sax.InputSource;

/**
 * Basic interface for the RDF parser.
 * 
 */
public interface RDFXMLParser {
    /**
     * the rdf parser will call the statement handler to export all the triples
     * generated during rdf parsing process
     * 
     * @param statementHandler
     *            the statement handler
     */
    void setStatementHandler(StatementHandler statementHandler);

    /**
     * the rdf parser will handle all the errors through the error handler
     * designated by this function call
     * 
     * @param errorHandler
     *            the error handler
     */
    void setErrorHandler(ErrorHandler errorHandler);

    /**
     * all the namespaces defined in rdf document will be exported by the
     * default namespace handler
     * 
     * @param namespaceHandler
     *            the namespace handler
     */
    void setNamespaceHandler(NamespaceHandler namespaceHandler);

    /**
     * an inputSource and a baseURI have to be specified into the rdf parser
     * before call the <code>parser(RDFSource source, String baseURI)</code>
     * method
     * 
     * @param source
     *            the rdf document source to be parsed
     * @param baseURI
     *            the base uri(default value)
     * @throws RStarIOException
     *             if the parser meets io exception during parsing rdf document
     * @throws ParserException
     *             if the parser meets invalid rdf document during paring
     *             process
     */
    void parse(InputSource source, String baseURI) throws ParserIOException,
            ParserException;
}