/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.model.ui.wizards;

import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Shell;

public abstract class InheritedColumnLabelProvider
extends ColumnLabelProvider {
    int inheritedForegroundColor;
    int inheritedBackgroundColor;
    Font cachedFont;

    public InheritedColumnLabelProvider(int inheritedForegroundColor, int inheritedBackgroundColor) {
        this.inheritedBackgroundColor = inheritedBackgroundColor;
        this.inheritedForegroundColor = inheritedForegroundColor;
    }

    abstract Shell getShell();

    abstract boolean isInherited(Object var1);

    public Font getFont(Object element) {
        Font font = super.getFont(element);
        if (this.isInherited(element)) {
            font = this.getInheritedFont(font);
        }
        return font;
    }

    private Font getInheritedFont(Font baseFont) {
        if (this.cachedFont == null) {
            if (baseFont == null) {
                baseFont = this.getShell().getDisplay().getSystemFont();
            }
            FontData fontData = baseFont.getFontData()[0];
            this.cachedFont = new Font((Device)this.getShell().getDisplay(), new FontData(fontData.getName(), fontData.getHeight(), 2));
        }
        return this.cachedFont;
    }

    public Color getForeground(Object element) {
        if (this.inheritedForegroundColor != 0 && this.isInherited(element)) {
            return this.getShell().getDisplay().getSystemColor(this.inheritedForegroundColor);
        }
        return super.getForeground(element);
    }

    public Color getBackground(Object element) {
        if (this.inheritedBackgroundColor != 0 && this.isInherited(element)) {
            return this.getShell().getDisplay().getSystemColor(this.inheritedBackgroundColor);
        }
        return super.getBackground(element);
    }
}

