/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.wizards;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.stem.core.STEMURI;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.experiment.Experiment;
import org.eclipse.stem.core.experiment.ExperimentFactory;
import org.eclipse.stem.ui.wizards.DublinCorePage;
import org.eclipse.stem.ui.wizards.Messages;
import org.eclipse.stem.ui.wizards.NewIdentifiablePage;
import org.eclipse.stem.ui.wizards.NewIdentifiableWizard;
import org.eclipse.stem.ui.wizards.STEMWizardDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class NewExperimentWizard
extends NewIdentifiableWizard {
    @Override
    protected String getWizardTitle() {
        return Messages.getString("NExperimentWiz.wizard_title");
    }

    @Override
    protected NewIdentifiablePage createNewIdentifiablePage() {
        NewExperimentPage retValue = new NewExperimentPage(Messages.getString("NExperimentWiz.page_title"));
        retValue.setTitle(Messages.getString("NExperimentWiz.page_title"));
        retValue.setDescription(Messages.getString("NExperimentWiz.page_description"));
        this.setHelpContextId("org.eclipse.stem.doc.newexperiment_contextid");
        return retValue;
    }

    @Override
    protected DublinCorePage createDublinCorePage() {
        return new DublinCorePage(){

            @Override
            protected void initializeDCAttributes() {
                super.initializeDCAttributes();
                this.format.setText("http:///org/eclipse/stem/core/experiment.ecore");
                this.format.setEnabled(false);
                this.type.setText(STEMURI.EXPERIMENT_TYPE_URI.toString());
                this.type.setEnabled(false);
                this.titleTextField.setText(Messages.getString("dc_title_exp"));
                this.source.setText(Messages.getString("dc_source_exp"));
                this.descriptionTextField.setText(Messages.getString("dc_desc_exp"));
            }
        };
    }

    @Override
    protected Identifiable createIdentifiable() {
        Experiment retValue = ExperimentFactory.eINSTANCE.createExperiment();
        retValue.setDublinCore(this.newDublinCorePage.createDublinCore());
        return retValue;
    }

    @Override
    protected String getSerializationFolderName() {
        return "experiments";
    }

    @Override
    protected String getSerializationFileNameExtension() {
        return "experiment";
    }

    protected static class NewExperimentPage
    extends NewIdentifiablePage {
        protected NewExperimentPage(String pageName) {
            super(pageName);
        }

        @Override
        protected Composite createSpecificComposite(Composite parent) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.stem.doc.newexperiment_contextid");
            return new Composite(parent, 0);
        }
    }

    public static class NewExperimentWizardCommandHandler
    extends AbstractHandler
    implements IHandler {
        public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
            IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)executionEvent);
            NewExperimentWizard wizard = new NewExperimentWizard();
            wizard.init(window.getWorkbench(), (IStructuredSelection)StructuredSelection.EMPTY);
            STEMWizardDialog wizardDialog = new STEMWizardDialog(window.getShell(), (IWizard)wizard);
            wizardDialog.open();
            return null;
        }
    }
}

