/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.utility.tests.iterators;

import java.util.Iterator;
import java.util.NoSuchElementException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.swingui.TestRunner;
import org.eclipse.dali.internal.utility.iterators.ArrayIterator;

public class ArrayIteratorTests
extends TestCase {
    static /* synthetic */ Class class$0;

    public static void main(String[] args) {
        String[] stringArray = new String[2];
        stringArray[0] = "-c";
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.utility.tests.iterators.ArrayIteratorTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[1] = clazz.getName();
        TestRunner.main((String[])stringArray);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.dali.utility.tests.iterators.ArrayIteratorTests");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public ArrayIteratorTests(String name) {
        super(name);
    }

    public void testHasNext() {
        int i = 0;
        Iterator stream = this.buildIterator();
        while (stream.hasNext()) {
            stream.next();
            ++i;
        }
        ArrayIteratorTests.assertEquals((int)this.buildArray().length, (int)i);
    }

    public void testNext() {
        int i = 0;
        Iterator stream = this.buildIterator();
        while (stream.hasNext()) {
            ArrayIteratorTests.assertEquals((String)"bogus element", (int)(++i), (int)Integer.parseInt((String)stream.next()));
        }
    }

    public void testNoSuchElementException() {
        boolean exCaught = false;
        Iterator stream = this.buildIterator();
        String string = null;
        while (stream.hasNext()) {
            string = (String)stream.next();
        }
        try {
            string = (String)stream.next();
        }
        catch (NoSuchElementException noSuchElementException) {
            exCaught = true;
        }
        ArrayIteratorTests.assertTrue((String)("NoSuchElementException not thrown: " + string), (boolean)exCaught);
    }

    public void testUnsupportedOperationException() {
        boolean exCaught = false;
        Iterator stream = this.buildIterator();
        while (stream.hasNext()) {
            if (!stream.next().equals("3")) continue;
            try {
                stream.remove();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                exCaught = true;
            }
        }
        ArrayIteratorTests.assertTrue((String)"UnsupportedOperationException not thrown", (boolean)exCaught);
    }

    public void testIllegalArgumentException() {
        this.triggerIllegalArgumentException(-1, 1);
        this.triggerIllegalArgumentException(8, 1);
        this.triggerIllegalArgumentException(0, -1);
        this.triggerIllegalArgumentException(0, 9);
    }

    public void triggerIllegalArgumentException(int start, int length) {
        boolean exCaught = false;
        Iterator stream = null;
        try {
            stream = this.buildIterator(start, length);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            exCaught = true;
        }
        ArrayIteratorTests.assertTrue((String)("IllegalArgumentException not thrown: " + stream), (boolean)exCaught);
    }

    Iterator buildIterator() {
        return this.buildIterator(this.buildArray());
    }

    Iterator buildIterator(Object[] array) {
        return new ArrayIterator(array);
    }

    Iterator buildIterator(int start, int length) {
        return this.buildIterator(this.buildArray(), start, length);
    }

    Iterator buildIterator(Object[] array, int start, int length) {
        return new ArrayIterator(array, start, length);
    }

    Object[] buildArray() {
        return new Object[]{"1", "2", "3", "4", "5", "6", "7", "8"};
    }
}

